/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CSecureObject.h,v 1.3 1999/09/23 23:50:54 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CSecureObject_h	// [
#define Included_CSecureObject_h

#include "pgpClassesConfig.h"

#include "CArray.h"
#include "CErrorState.h"

_PGP_BEGIN

// Class CSecureObject

template <typename T> class CSecureObject SMART_ERROR_INHERIT
{
	NOT_COPYABLE(CSecureObject)

public:
	CSecureObject();
	~CSecureObject();

	operator T *() {return mObject;}
	operator const T *() const {return mObject;}

	T *			operator->() {return mObject;}
	const T *	operator->() const {return mObject;}

	T&			operator*() {return *mObject;}
	const T&	operator*() const {return *mObject;}

	T *	Get() {return mObject;}

	void	FlipBytes();
	void	Wipe() {mBuffer.Wipe();}

private:
	CSecureArray<PGPByte>	mBuffer;	// buffer for object
	T						*mObject;	// pointer to constructed object
};


// Class CSecureObject member functions

template <typename T> 
CSecureObject<T>::CSecureObject() : mBuffer(sizeof(T)), mObject(NULL)
{
	// Use placement new to construct the object on the secure memory.

#if !PGP_EXCEPTIONS
	Status() = mBuffer.Status();

	if (Status().IsntError())
#endif	// !PGP_EXCEPTIONS
		mObject = new(mBuffer.Get()) T;
}

template <typename T> 
CSecureObject<T>::~CSecureObject()
{
	if (IsntNull(mObject))
	{
		// Destuct the object on the secure memory.
		mObject->~T();
		mObject = NULL;
	}
}

template <typename T> 
void 
CSecureObject<T>::FlipBytes()
{
	for (PGPUInt32 i = 0; i < mBuffer.Size(); i++)
	{
		mBuffer[i] = ~mBuffer[i];
	}
}

_PGP_END

#endif	// ] Included_CSecureObject_h
